// This file is a part of MPDN Extensions.
// https://github.com/zachsaw/MPDN_Extensions
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 3.0 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library.
// 
sampler SourceSampler: register(s0);  // x = ImageVariance; y = Image (luma)
float4 floatConsts1 : register(c0);
#define pixSize (floatConsts1.xy)
#define limit (floatConsts1.z)
#define sqr(value) ((value)*(value))
#define getPix(posx, posy) (tex2D(SourceSampler, tex + float2(posx, posy) * pixSize).yx)
#define varPix(pix) (sqr(pix.x - convolved.x))

float4 main(float2 tex : TEXCOORD0) : COLOR
{
  float2 pix00 = getPix(-1, -1);
  float2 pix10 = getPix( 0, -1);
  float2 pix20 = getPix(+1, -1);
  float2 pix01 = getPix(-1,  0);
  float2 pix11 = getPix( 0,  0);
  float2 pix21 = getPix(+1,  0);
  float2 pix02 = getPix(-1, +1);
  float2 pix12 = getPix( 0, +1);
  float2 pix22 = getPix(+1, +1);
  float2 convolved = 0.36 *        pix11  + 0.12 * (       pix01  +        pix10  +        pix12  +        pix21 ) + 0.04 * (       pix00  +        pix22  +        pix02  +        pix20 );
  float  variance  = 0.36 * varPix(pix11) + 0.12 * (varPix(pix01) + varPix(pix10) + varPix(pix12) + varPix(pix21)) + 0.04 * (varPix(pix00) + varPix(pix22) + varPix(pix02) + varPix(pix20));
  float R = (variance < 1e-10) ? (0.0) : min(limit, sqrt(1.0 + convolved.y / variance));
  float T = (1.0 - R) * convolved.x;
  return float4(R, T, R * R, 0);
}
