// This file is a part of MPDN Extensions.
// https://github.com/zachsaw/MPDN_Extensions
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 3.0 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library.
// 
sampler sOrg : register(s0);
sampler sWip : register(s2);
sampler sDif : register(s3);
float4 originalSize : register(c0);
float4 args0 : register(c1);
#define acuity 6.0
#define strength (args0[0])
#define radius (args0[1])
#define ddxddy (originalSize.zw)
#define chromaOffset (args0.zw)
#define sqr(x) dot(x,x)
#define Dif(x,y) (tex2D(sDif,ddxddy*(pos+int2(x,y)+0.5)))
#define Org(x,y) (tex2D(sOrg,ddxddy*(pos+int2(x,y)+0.5)))
float4 degammaConsts : register(c2);
#define degammaValue (degammaConsts[0])
#define degammaValueInv (degammaConsts[1])
#define degammaThreshold (degammaConsts[2])
#define degammaFactor (degammaConsts[3])
float4 engammaConsts : register(c3);
#define engammaValue (engammaConsts[0])
#define engammaValueInv (engammaConsts[1])
#define engammaThreshold (engammaConsts[2])
#define engammaFactor (engammaConsts[3])
float4 addConstMath : register(c4);
float4x4 mulConstMath : register(c5);
float4x4 satHueMatrix : register(c9);
float4x4 gamutConversion : register(c13);
float4x4 rgb2xyz : register(c17);
float4x4 xyz2rgb : register(c21);
float4 floatConsts1 : register(c25);
float4 floatConsts2 : register(c26);
float4 floatConsts3 : register(c27);
float4 floatConsts4 : register(c28);
float4 floatConsts5 : register(c29);
float4 floatConsts6 : register(c30);
float4 floatConsts7 : register(c31);
#define sigmoidalContrast (floatConsts1[0])
#define sigmoidalWhatever (floatConsts1[1])  // tanh(0.25 * sigmoidalContrast)
#define slopes (floatConsts2.xyz)
#define yIntercepts (floatConsts3.xyz)
#define whitePoint (floatConsts4.xy)
#define hdrLogConstant (floatConsts4[2])
#define hdrNitsFactor (floatConsts4[3])
#define hdrContentLimit (floatConsts5[0])
#define hdrClipFactor (floatConsts5[1])
#define spline_v (floatConsts6[0])
#define spline_w (floatConsts6[1])
#define spline_s (floatConsts6[2])
#define spline_t (floatConsts6[3])
#define spline_a (floatConsts7[0])
#define spline_b (floatConsts7[1])
#define spline_c (floatConsts7[2])
#define spline_d (floatConsts7[3])

float4 main(float2 tex : TEXCOORD0) : COLOR
{
  float3 c0 = tex2D(sWip, tex);
  float2 pos = tex * originalSize.xy - chromaOffset - 0.5;
  float2 offset = pos - floor(pos);
  pos -= offset;
  float weightSum = 0;
  float2 dif = 0;
  float2 org = Org(0, 0);
  float2 orgMaxDif = 0;
  [unroll] for (int X = -1; X <= 2; X++)
  [unroll] for (int Y = -1; Y <= 2; Y++)
  {
      if ((abs(X) < 2) && (abs(Y) < 2))
        orgMaxDif = max(orgMaxDif, abs(Org(X, Y) - org));
      float4 difRead = Dif(X, Y);
      float2 dI2 = sqr(acuity * c0.yz - difRead.ba);
      float dXY2 = sqr(float2(X, Y) - offset);
      float2 weight = exp(-dXY2 / (2 * radius)) / (1 + dI2);
      dif += weight * difRead.xy;
      weightSum += weight;
  }
  float2 factor = saturate(orgMaxDif * 255.0 / 32.0);
  c0.yz -= (strength * dif / weightSum) * factor;
  float4 result = float4(c0, 0);;
  return result;
}
