// This file is a part of MPDN Extensions.
// https://github.com/zachsaw/MPDN_Extensions
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 3.0 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library.
// 
#define acuity 100.0
#define radius 0.66
#define power 0.5
sampler sY  : register(s0);
sampler sUV : register(s1);
float4 chromaSize : register(c0);
float4 args0 : register(c1);
#define ddxddy (chromaSize.zw)
#define chromaOffset (args0.xy)
#define sqr(x) dot(x,x)
#define GetY(x,y)  (tex2D(sY,ddxddy*(pos+chromaOffset+int2(x,y)+0.5)).r)
#define GetUV(x,y) (tex2D(sUV,ddxddy*(pos+int2(x,y)+0.5)).rg)

float4 main(float2 tex : TEXCOORD0) : COLOR
{
    float2 pos = tex * chromaSize.xy - chromaOffset - 0.5;
    float2 offset = pos - round(pos);
    pos -= offset;
    float y = tex2D(sY, tex).r;
    float2 uv = 0;
    float weightSum = 0;
    [unroll] for (int X = -1; X <= 1; X++)
    [unroll] for (int Y = -1; Y <= 1; Y++)
    {
        float dI2 = sqr(acuity*(y - GetY(X, Y)));
        float dXY2 = sqr(float2(X, Y) - offset);
        float weight = exp(-dXY2 / (2 * radius * radius)) * pow(1 + dI2 / power, - power);
        uv += weight * GetUV(X, Y);
        weightSum += weight;
    }
    return float4(uv / weightSum, 0, 0);
}
