// This file is a part of MPDN Extensions.
// https://github.com/zachsaw/MPDN_Extensions
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 3.0 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library.
// 
sampler SourceSampler: register(s0);
sampler RTSampler: register(s2);
float4 floatConsts1 : register(c0);
#define pixSize (floatConsts1.xy)
#define detailLevel (floatConsts1.z)
#define getRT(posx, posy) (tex2D(RTSampler, tex + float2(posx, posy) * pixSize).xyz)
// #define ProcessOutput(yuv) (yuv)

float4 main(float2 tex : TEXCOORD0) : COLOR
{
  float3 RTc = 0.36 * getRT(0, 0) + 0.12 * (getRT(-1, 0) + getRT(0, -1) + getRT(0, +1) + getRT(+1, 0)) + 0.04 * (getRT(-1, -1) + getRT(+1, +1) + getRT(-1, +1) + getRT(+1, -1));
  float4 yuv = tex2D(SourceSampler, tex).yzwy;
  yuv.x = lerp(RTc.y + RTc.x * yuv.x, yuv.x, 1.0 - 1.0 / (1.0 + RTc.z / detailLevel));
  return ProcessOutput(yuv);
}
