// This file is a part of MPDN Extensions.
// https://github.com/zachsaw/MPDN_Extensions
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 3.0 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library.
// 
sampler sWip : register(s0);
sampler sDif : register(s2);
sampler sOrg : register(s3);
float4 originalSize : register(c0);
float4 args0 : register(c1);
#define acuity 6.0
#define strength (args0[0])
#define radius (args0[1])
#define ddxddy (originalSize.zw)
#define sqr(x) dot(x,x)
#define Dif(x,y) (tex2D(sDif,ddxddy*(pos+int2(x,y)+0.5)))
#define Org(x,y) (mul(rgbToHd, tex2D(sOrg,ddxddy*(pos+int2(x,y)+0.5)).rgb)[0])
static float3x3 rgbToHd = {+0.2126000000000000, +0.7152000000000000, +0.0722000000000000,
                           -0.1145721060573400, -0.3854278939426600, +0.5000000000000000,
                           +0.5000000000000000, -0.4541529083058166, -0.0458470916941834};

float4 main(float2 tex : TEXCOORD0) : COLOR
{
  float3 c0 = tex2D(sWip, tex);
  c0 = c0 < 0.018 ? c0 * 4.506198600878514 : 1.099 * pow(c0, 0.45) - 0.099;
  float2 pos = tex * originalSize.xy - 0.5;
  float2 offset = pos - floor(pos);
  pos -= offset;
  float weightSum = 0;
  float3 dif = 0;
  float org = Org(0, 0);
  float orgMaxDif = 0;
  [unroll] for (int X = -1; X <= 2; X++)
  [unroll] for (int Y = -1; Y <= 2; Y++)
  {
    if ((abs(X) < 2) && (abs(Y) < 2))
      orgMaxDif = max(orgMaxDif, abs(Org(X, Y) - org));
    float4 difRead = Dif(X, Y);
    float dI2 = sqr(acuity * (mul(rgbToHd, c0).x - difRead.a));
    float dXY2 = sqr(float2(X, Y) - offset);
    float weight = exp(-dXY2 / (2 * radius)) / (1 + dI2);
    dif += weight * difRead.rgb;
    weightSum += weight;
  }
  float factor = saturate(orgMaxDif * 255.0 / 32.0);
  c0 -= (strength * dif / weightSum) * factor;
  return float4(c0, 0);
}
