// This file is a part of MPDN Extensions.
// https://github.com/zachsaw/MPDN_Extensions
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 3.0 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library.
// 
sampler src1 : register(s0);
sampler src2 : register(s2);
static float3x3 rgbToHd = {+0.2126000000000000, +0.7152000000000000, +0.0722000000000000,
                           -0.1145721060573400, -0.3854278939426600, +0.5000000000000000,
                           +0.5000000000000000, -0.4541529083058166, -0.0458470916941834};

float4 main(float2 tex : TEXCOORD0) : COLOR0
{
  float3 c0 = tex2D(src1, tex).xyz;
  c0 = c0 < 0.018 ? c0 * 4.506198600878514 : 1.099 * pow(c0, 0.45) - 0.099;
  float3 c1 = tex2D(src2, tex).xyz;
  return float4(c0 - c1, mul(rgbToHd, c0).x);
}
