// This file is a part of MPDN Extensions.
// https://github.com/zachsaw/MPDN_Extensions
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 3.0 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library.
// 
sampler YSampler : register(s0);
float4 floatConsts1 : register(c0);
float4 floatConsts2 : register(c1);
float4 floatConsts3 : register(c2);
#define inputSize (floatConsts1.xy)
#define inputPixSize (floatConsts1.zw)
#define outputSize (floatConsts2.xy)
#define outputPixSize (floatConsts2.zw)
#define offset (floatConsts3.xy)
#define factor (inputPixSize.x * outputSize.x)
#define taps (1 + factor)

float4 main(float2 tex : TEXCOORD0) : COLOR
{
  int low  = floor((tex.x - 0.5 * taps * outputPixSize.x) * inputSize.x - offset.x + 0.5);
  int high = floor((tex.x + 0.5 * taps * outputPixSize.x) * inputSize.x - offset.x + 0.5);
  float weightSum = 0;
  float2 avg = 0;
  float2 pos = tex;
  [loop] [fastopt] for (int k = 0; k < high - low; k++)
  {
    pos.x = inputPixSize.x * (k + low + 0.5);
    float rel = (pos.x - tex.x) * outputSize.x + offset.x * factor;
    float weight = saturate(0.5 + (0.5 - abs(rel)) / factor);
    float2 pix = tex2D(YSampler, pos, 0, 0);
    pix = float2(pix[0], pix[0] * pix[0]);
    avg += weight * pix;
    weightSum += weight;
  }
  avg /= weightSum;
  return float4(avg[0], avg[1] - avg[0] * avg[0], 0, 0);
}
